function x = DonjeTrougaoniSistem( A, b )

[m, n] = size( A );
[k, l] = size( b );
if m ~= n
    error( 'GRESKA: Matrica mora da bude kvadratna!!!' )
elseif l ~= 1
    error( 'GRESKA: Vektor b mora da bude vektor kolona!!!' )
elseif m ~= k
    error( 'GRESKA: Vektor b mora da bude iste dimenzije kao i matrica A!!!' )
else
    for i = 1 : m - 1
        for j = i + 1 : m
            if A( i, j ) ~= 0
                error( 'GRESKA: Matrica mora da bude donje trougaona!!!' )
            end
        end
    end
    if abs( det( A ) ) <= eps
        error( 'GRESKA: Matrica mora da bude regularna!!!' )
    end
end

x = zeros( m, 1 );
x( 1 ) = b( 1 ) / A( 1, 1 );
for j = 2 : m
    k = 1 : j - 1;
    y = x( k );
    a = A( j, k )';
    x( j ) = ( b( j ) - sum( a .* y ) ) / A( j , j );
end